
$(document).ready(function () {
  "use strict";
  $(".table").on("click", ".editbutton", function () {

    var iid = $(this).attr("data-id");
    $(".consultant_fee_div").addClass("hidden");
    $(".pay_now").addClass("hidden");
    $(".payment_status").addClass("hidden");
    $(".deposit_type1").addClass("hidden");
    $("#editAppointmentForm").trigger("reset");
    $("#myModal2").modal("show");
    $.ajax({
      url: "appointment/editAppointmentByJason?id=" + iid,
      method: "GET",
      data: "",
      dataType: "json",
      success: function (response) {
        "use strict";
        var de = response.appointment.date * 1000;
        var d = new Date(de);

        var da = d.getDate() + "-" + (d.getMonth() + 1) + "-" + d.getFullYear();
        // Populate the form fields with the data returned from server
        $("#editAppointmentForm")
          .find('[name="id"]')
          .val(response.appointment.id)
          .end();
        $("#editAppointmentForm")
          .find('[name="patient"]')
          .val(response.appointment.patient)
          .end();
        $("#editAppointmentForm")
          .find('[name="doctor"]')
          .val(response.appointment.doctor)
          .end();
        $("#editAppointmentForm")
          .find('[name="date"]')
          .val(da)
          .trigger("change");
        $("#editAppointmentForm")
          .find('[name="status"]')
          .val(response.appointment.status)
          .end();
        $("#editAppointmentForm")
          .find('[name="remarks"]')
          .val(response.appointment.remarks)
          .end();

        var option = new Option(
          response.patient.name + "-" + response.patient.id,
          response.patient.id,
          true,
          true
        );
        $("#editAppointmentForm")
          .find('[name="patient"]')
          .append(option)
          .trigger("change");
        var option1 = new Option(
          response.doctor.name + "-" + response.doctor.id,
          response.doctor.id,
          true,
          true
        );
        $("#editAppointmentForm")
          .find('[name="doctor"]')
          .append(option1)
          .trigger("change");
        $("#visit_description1").html("");
        $.ajax({
          url:
            "doctor/getDoctorVisitForEdit?id=" +
            response.doctor.id +
            "&description=" +
            response.appointment.visit_description,
          method: "GET",
          data: "",
          dataType: "json",
          success: function (response1) {
            $("#visit_description1").html(response1.response).end();
            // $('#editAppointmentForm').find('[name="visit_description"]').val(response.appointment.visit_description).trigger('change').end();
          },
        });
        if (response.appointment.payment_status == "unpaid") {
          $(".consultant_fee_div").removeClass("hidden");
          $(".pay_now").removeClass("hidden");
          $(".payment_status").addClass("hidden");
          $('.status_paid_hidden_section').removeClass('hidden');
          $('#visit_description1').css('pointer-events', "auto");
          $('.card1').addClass('hidden');
          // $('.deposit_type1').removeClass('hidden');
          $("#editAppointmentForm")
            .find('[name="visit_charges"]')
            .val(response.appointment.visit_charges)
            .end();
          $("#editAppointmentForm")
            .find('[name="discount"]')
            .val(response.appointment.discount)
            .end();
          $("#editAppointmentForm")
            .find('[name="grand_total"]')
            .val(response.appointment.grand_total)
            .end();
        } else {
          $(".payment_status").removeClass("hidden");
          $(".pay_now").addClass("hidden");
          $(".consultant_fee_div").addClass("hidden");
          $('.status_paid_hidden_section').addClass('hidden');
          $('.card1').addClass('hidden');
          // $('.deposit_type1').addClass('hidden');
          $('#visit_description1').css('pointer-events', "none");
          $("#editAppointmentForm")
            .find('[id="adoctors1"]')
            .select2([
              {
                id: response.doctor.id,
                text: response.doctor.name + "-" + response.doctor.id,
                locked: true,
              },
            ]);

          $("#editAppointmentForm")
            .find('[id="pos_select1"]')
            .select2([
              {
                id: response.patient.id,
                text: response.patient.name + "-" + response.patient.id,
                locked: true,
              },
            ]);

        }
        var date = $("#date1").val();
        var doctorr = $("#adoctors1").val();
        var appointment_id = $("#appointment_id").val();
        $.ajax({
          url:
            "schedule/getAvailableSlotByDoctorByDateByAppointmentIdByJason?date=" +
            date +
            "&doctor=" +
            doctorr +
            "&appointment_id=" +
            appointment_id,
          method: "GET",
          data: "",
          dataType: "json",
          success: function (response) {
            "use strict";
            $("#aslots1").find("option").remove();
            var slots = response.aslots;
            $.each(slots, function (key, value) {
              "use strict";
              $("#aslots1").append($("<option>").text(value).val(value)).end();
            });

            $("#aslots1").val(response.current_value).trigger("change");

            if ($("#aslots1").has("option").length == 0) {
              //if it is blank.
              $("#aslots1")
                .append(
                  $("<option>")
                    .text("No Further Time Slots")
                    .val("Not Selected")
                )
                .end();
            }
          },
        });
      },
    });
  });

  $(".table").on("click", ".history", function () {
    "use strict";

    var iid = $(this).attr("data-id");

    $("#editAppointmentForm").trigger("reset");
    $.ajax({
      url: "patient/getMedicalHistoryByjason?id=" + iid,
      method: "GET",
      data: "",
      dataType: "json",
      success: function (response) {
        "use strict";
        $("#medical_history").html("");
        $("#medical_history").append(response.view);
      },
    });
    $("#cmodal").modal("show");
  });

  $(".doctor_div").on("change", "#adoctors", function () {
    "use strict";
    var iid = $("#date").val();
    var doctorr = $("#adoctors").val();
    $("#aslots").find("option").remove();
    if (iid != '') {
      $.ajax({
        url:
          "schedule/getAvailableSlotByDoctorByDateByJason?date=" +
          iid +
          "&doctor=" +
          doctorr,
        method: "GET",
        data: "",
        dataType: "json",
        success: function (response) {
          "use strict";
          var slots = response.aslots;
          $.each(slots, function (key, value) {
            "use strict";
            $("#aslots").append($("<option>").text(value).val(value)).end();
          });

          if ($("#aslots").has("option").length == 0) {
            //if it is blank.
            $("#aslots")
              .append(
                $("<option>").text("No Further Time Slots").val("Not Selected")
              )
              .end();
          }
        },
      });
    }
    $("#visit_description").html(" ");
    $("#visit_charges").val(" ");
    $.ajax({
      url: "doctor/getDoctorVisit?id=" + doctorr,
      method: "GET",
      data: "",
      dataType: "json",
      success: function (response1) {
        $("#visit_description").html(response1.response).end();
      },
    });
  });

  function initTable(selector, options) {
    if (!$.fn.DataTable) {
      return null;
    }
    if (!$(selector).length) {
      return null;
    }
    try {
      return $(selector).DataTable(options);
    } catch (e) {
      return null;
    }
  }

  initTable('#editable-sample1', {
      "processing": true,
      "serverSide": true,
      "searchable": true,
      "ajax": {
          "url": "appointment/getPendingAppoinmentList",
          "type": "POST"
      },
      "order": [[ 0, "desc" ]],
      "dom": "<'row'<'col-sm-3'l><'col-sm-5 text-center'B><'col-sm-4'f>>" +
              "<'row'<'col-sm-12'tr>>" +
              "<'row'<'col-sm-5'i><'col-sm-7'p>>",
      "buttons": [
          'copyHtml5',
          'excelHtml5',
          'csvHtml5',
          'pdfHtml5',
          {
              extend: 'print',
              exportOptions: {
                  columns: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9],
              }
          },
      ],
      "aLengthMenu": [
          [10, 25, 50, 100, -1],
          [10, 25, 50, 100, "All"]
      ],
      "iDisplayLength": 100,
      "aoColumns": [
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          { "bSortable": false }
      ]
  });

  initTable('#editable-sample2', {
      "processing": true,
      "serverSide": true,
      "searchable": true,
      "ajax": {
          "url": "appointment/getConfirmedAppoinmentList",
          "type": "POST"
      },
      "order": [[ 0, "desc" ]],
      "dom": "<'row'<'col-sm-3'l><'col-sm-5 text-center'B><'col-sm-4'f>>" +
              "<'row'<'col-sm-12'tr>>" +
              "<'row'<'col-sm-5'i><'col-sm-7'p>>",
      "buttons": [
          'copyHtml5',
          'excelHtml5',
          'csvHtml5',
          'pdfHtml5',
          {
              extend: 'print',
              exportOptions: {
                  columns: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9],
              }
          },
      ],
      "aLengthMenu": [
          [10, 25, 50, 100, -1],
          [10, 25, 50, 100, "All"]
      ],
      "iDisplayLength": 100,
      "aoColumns": [
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          { "bSortable": false }
      ]
  });

  initTable('#editable-sample3', {
      "processing": true,
      "serverSide": true,
      "searchable": true,
      "ajax": {
          "url": "appointment/getTreatedAppoinmentList",
          "type": "POST"
      },
      "order": [[ 0, "desc" ]],
      "dom": "<'row'<'col-sm-3'l><'col-sm-5 text-center'B><'col-sm-4'f>>" +
              "<'row'<'col-sm-12'tr>>" +
              "<'row'<'col-sm-5'i><'col-sm-7'p>>",
      "buttons": [
          'copyHtml5',
          'excelHtml5',
          'csvHtml5',
          'pdfHtml5',
          {
              extend: 'print',
              exportOptions: {
                  columns: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9],
              }
          },
      ],
      "aLengthMenu": [
          [10, 25, 50, 100, -1],
          [10, 25, 50, 100, "All"]
      ],
      "iDisplayLength": 100,
      "aoColumns": [
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          { "bSortable": false }
      ]
  });

  initTable('#editable-sample4', {
      "processing": true,
      "serverSide": true,
      "searchable": true,
      "ajax": {
          "url": "appointment/getCancelledAppoinmentList",
          "type": "POST"
      },
      "order": [[ 0, "desc" ]],
      "dom": "<'row'<'col-sm-3'l><'col-sm-5 text-center'B><'col-sm-4'f>>" +
              "<'row'<'col-sm-12'tr>>" +
              "<'row'<'col-sm-5'i><'col-sm-7'p>>",
      "buttons": [
          'copyHtml5',
          'excelHtml5',
          'csvHtml5',
          'pdfHtml5',
          {
              extend: 'print',
              exportOptions: {
                  columns: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9],
              }
          },
      ],
      "aLengthMenu": [
          [10, 25, 50, 100, -1],
          [10, 25, 50, 100, "All"]
      ],
      "iDisplayLength": 100,
      "aoColumns": [
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          { "bSortable": false }
      ]
  });

  initTable('#editable-sample5', {
      "processing": true,
      "serverSide": true,
      "searchable": true,
      "ajax": {
          "url": "appointment/getAppoinmentList",
          "type": "POST"
      },
      "order": [[ 0, "desc" ]],
      "dom": "<'row'<'col-sm-3'l><'col-sm-5 text-center'B><'col-sm-4'f>>" +
              "<'row'<'col-sm-12'tr>>" +
              "<'row'<'col-sm-5'i><'col-sm-7'p>>",
      "buttons": [
          'copyHtml5',
          'excelHtml5',
          'csvHtml5',
          'pdfHtml5',
          {
              extend: 'print',
              exportOptions: {
                  columns: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9],
              }
          },
      ],
      "aLengthMenu": [
          [10, 25, 50, 100, -1],
          [10, 25, 50, 100, "All"]
      ],
      "iDisplayLength": 100,
      "aoColumns": [
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          { "bSortable": false }
      ]
  });

  initTable('#editable-sample6', {
      "processing": true,
      "serverSide": true,
      "searchable": true,
      "ajax": {
          "url": "appointment/getRequestedAppointmentList",
          "type": "POST"
      },
      "order": [[ 0, "desc" ]],
      "dom": "<'row'<'col-sm-3'l><'col-sm-5 text-center'B><'col-sm-4'f>>" +
              "<'row'<'col-sm-12'tr>>" +
              "<'row'<'col-sm-5'i><'col-sm-7'p>>",
      "buttons": [
          'copyHtml5',
          'excelHtml5',
          'csvHtml5',
          'pdfHtml5',
          {
              extend: 'print',
              exportOptions: {
                  columns: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9],
              }
          },
      ],
      "aLengthMenu": [
          [10, 25, 50, 100, -1],
          [10, 25, 50, 100, "All"]
      ],
      "iDisplayLength": 100,
      "aoColumns": [
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          { "bSortable": false }
      ]
  });

  // Mark as Waiting button click handler
  $(".table").on("click", ".mark-waiting", function () {
    var id = $(this).attr("data-id");
    var $btn = $(this);

    if (confirm("Are you sure you want to mark this appointment as waiting?")) {
      $.ajax({
        url: "appointment/markAsWaiting?id=" + id,
        method: "GET",
        dataType: "json",
        success: function (response) {
          if (response.success) {
            // Reload the table containing the button
            try {
              var table = $btn.closest("table").DataTable();
              table.ajax.reload(null, false);
            } catch (e) {
            }
          } else {
            alert("Error updating appointment");
          }
        },
        error: function () {
          alert("Error updating appointment");
        },
      });
    }
  });

  $(".table").on("click", ".consultation-started", function () {
    var id = $(this).attr("data-id");
    var $btn = $(this);
    if (!id) {
      return;
    }

    $btn.prop("disabled", true);
    $.ajax({
      url: "appointment/consultationStarted?id=" + id,
      method: "GET",
      dataType: "json",
      success: function (response) {
        if (!response || response.success !== true) {
          $btn.prop("disabled", false);
          return;
        }

        var row = $btn.closest("tr");
        var timer = row.find(".waiting-timer");
        if (timer.length && response.end_seconds) {
          timer.attr("data-end", response.end_seconds);
        }
        updateWaitingTimers();
        try {
          var table = $btn.closest("table").DataTable();
          table.ajax.reload(null, false);
        } catch (e) {
        }
      },
      error: function () {
        $btn.prop("disabled", false);
      },
    });
  });

  // Timer logic
  function parseStartTimeSeconds(rawValue) {
    if (rawValue === undefined || rawValue === null) {
      return null;
    }

    var value = String(rawValue).trim();
    if (!value) {
      return null;
    }

    if (/^\d+$/.test(value)) {
      var numericValue = parseInt(value, 10);
      if (!isNaN(numericValue)) {
        while (numericValue > 9999999999) {
          numericValue = Math.floor(numericValue / 1000);
        }
        if (numericValue >= 1000000000) {
          return numericValue;
        }
      }
      return null;
    }

    var dateTimeMatch = value.match(/^(\d{4})-(\d{2})-(\d{2})(?:[ T](\d{2}):(\d{2})(?::(\d{2})(?:\.\d+)?)?)?$/);
    if (dateTimeMatch) {
      var year = parseInt(dateTimeMatch[1], 10);
      var month = parseInt(dateTimeMatch[2], 10) - 1;
      var day = parseInt(dateTimeMatch[3], 10);
      var hour = dateTimeMatch[4] ? parseInt(dateTimeMatch[4], 10) : 0;
      var minute = dateTimeMatch[5] ? parseInt(dateTimeMatch[5], 10) : 0;
      var second = dateTimeMatch[6] ? parseInt(dateTimeMatch[6], 10) : 0;
      var localMs = new Date(year, month, day, hour, minute, second).getTime();
      var utcMs = Date.UTC(year, month, day, hour, minute, second);
      if (!isNaN(localMs) && !isNaN(utcMs)) {
        var nowSeconds = Math.floor(Date.now() / 1000);
        var localSeconds = Math.floor(localMs / 1000);
        var utcSeconds = Math.floor(utcMs / 1000);
        if (localSeconds - nowSeconds > 3600 && utcSeconds - nowSeconds <= 3600) {
          return utcSeconds;
        }
        if (utcSeconds - nowSeconds > 3600 && localSeconds - nowSeconds <= 3600) {
          return localSeconds;
        }
        return localSeconds;
      }
    }

    var dateTimeDmyMatch = value.match(/^(\d{2})-(\d{2})-(\d{4})(?:[ T](\d{2}):(\d{2})(?::(\d{2})(?:\.\d+)?)?)?$/);
    if (dateTimeDmyMatch) {
      var day2 = parseInt(dateTimeDmyMatch[1], 10);
      var month2 = parseInt(dateTimeDmyMatch[2], 10) - 1;
      var year2 = parseInt(dateTimeDmyMatch[3], 10);
      var hour2 = dateTimeDmyMatch[4] ? parseInt(dateTimeDmyMatch[4], 10) : 0;
      var minute2 = dateTimeDmyMatch[5] ? parseInt(dateTimeDmyMatch[5], 10) : 0;
      var second2 = dateTimeDmyMatch[6] ? parseInt(dateTimeDmyMatch[6], 10) : 0;
      var localMs2 = new Date(year2, month2, day2, hour2, minute2, second2).getTime();
      var utcMs2 = Date.UTC(year2, month2, day2, hour2, minute2, second2);
      if (!isNaN(localMs2) && !isNaN(utcMs2)) {
        var nowSeconds2 = Math.floor(Date.now() / 1000);
        var localSeconds2 = Math.floor(localMs2 / 1000);
        var utcSeconds2 = Math.floor(utcMs2 / 1000);
        if (localSeconds2 - nowSeconds2 > 3600 && utcSeconds2 - nowSeconds2 <= 3600) {
          return utcSeconds2;
        }
        if (utcSeconds2 - nowSeconds2 > 3600 && localSeconds2 - nowSeconds2 <= 3600) {
          return localSeconds2;
        }
        return localSeconds2;
      }
    }

    var ms = Date.parse(value);
    if (!isNaN(ms)) {
      return Math.floor(ms / 1000);
    }

    return null;
  }

  function pad2(numberValue) {
    return numberValue < 10 ? "0" + numberValue : String(numberValue);
  }

  function formatDurationSeconds(totalSeconds) {
    if (totalSeconds < 0) {
      totalSeconds = 0;
    }

    var days = Math.floor(totalSeconds / 86400);
    var remainder = totalSeconds % 86400;
    var hours = Math.floor(remainder / 3600);
    var minutes = Math.floor((remainder % 3600) / 60);
    var seconds = remainder % 60;

    var timeString = pad2(hours) + ":" + pad2(minutes) + ":" + pad2(seconds);
    return days > 0 ? days + "d " + timeString : timeString;
  }

  function updateWaitingTimers() {
    $(".waiting-timer").each(function () {
      var startSeconds = parseStartTimeSeconds($(this).attr("data-start"));
      if (startSeconds === null) {
        $(this).text("");
        return;
      }

      var endSeconds = parseStartTimeSeconds($(this).attr("data-end"));
      var nowSeconds = Math.floor(Date.now() / 1000);
      if (startSeconds > nowSeconds) {
        startSeconds = nowSeconds;
        $(this).attr("data-start", String(startSeconds));
      }
      if (endSeconds !== null && endSeconds < startSeconds) {
        endSeconds = null;
      }
      var diffSeconds = endSeconds !== null ? endSeconds - startSeconds : nowSeconds - startSeconds;
      if (diffSeconds < 0) {
        $(this).text("00:00:00");
        return;
      }

      $(this).text(formatDurationSeconds(diffSeconds));
    });
  }

  updateWaitingTimers();
  setInterval(function () {
    updateWaitingTimers();
  }, 1000);
});
